<?php

namespace App\Notifications\User;

use App\Models\Team;
use App\Models\Tournament;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class PlayerInvitationNotification extends BaseNotification
{
    public function __construct(
        protected Team $team,
        protected Tournament $tournament
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Invitation to Join Team "' . ($this->team->name ?? 'Team') . '"')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('You have been invited to join the team "' . ($this->team->name ?? 'Team') . '" as a player.')
            ->line('Tournament: ' . ($this->tournament->name ?? ''))
            ->action('Review Invitation', url('/player/profile'))
            ->line('If you did not expect this, you can safely ignore the invitation.');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Player Invitation',
            'message' => 'You were invited to join team "' . ($this->team->name ?? 'Team') . '" as a player in ' . ($this->tournament->name ?? ''),
            'type' => 'player_invitation',
            'data' => [
                'team_id' => $this->team->id,
                'team_name' => $this->team->name,
                'tournament_id' => $this->tournament->id,
                'tournament_name' => $this->tournament->name,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'Review Invitation',
        ];
    }
}
