<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class ParticipationCertificateAvailableNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null,
        protected ?int $playerId = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Participation Certificate Available')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your participation certificate is now available for ' . ($this->tournamentName ?? ''))
            ->action('Download Certificate', url('/players/certificates'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Certificate Available',
            'message' => 'Your certificate is available for ' . ($this->tournamentName ?? ''),
            'type' => 'certificate_available',
            'data' => [
                'tournament_name' => $this->tournamentName,
                'player_id' => $this->playerId,
            ],
            'action_url' => url('/players/certificates'),
            'action_text' => 'Download Certificate',
        ];
    }
}
