<?php

namespace App\Notifications\User;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialVerifiedNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Status Verified - ' . $this->official->team->name)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Congratulations! Your official status for team ' . $this->official->team->name . ' has been verified.')
            ->line('Role: ' . $this->official->role)
            ->line('You now have full access to all official features and responsibilities.')
            ->action('View Team Profile', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Status Verified',
            'message' => 'Your official status for team ' . $this->official->team->name . ' has been verified. Role: ' . $this->official->role,
            'type' => 'official_verified',
            'data' => [
                'official_id' => $this->official->id,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'role' => $this->official->role,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team Profile',
        ];
    }
}
