<?php

namespace App\Notifications\User;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialRoleChangedNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official,
        protected string $oldRole,
        protected string $newRole
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Role Updated - ' . $this->official->team->name)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your role as an official for team ' . $this->official->team->name . ' has been updated.')
            ->line('Previous role: ' . $this->oldRole)
            ->line('New role: ' . $this->newRole)
            ->action('View Team Profile', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Role Updated',
            'message' => 'Your role has been changed from ' . $this->oldRole . ' to ' . $this->newRole . ' for team ' . $this->official->team->name,
            'type' => 'official_role_changed',
            'data' => [
                'official_id' => $this->official->id,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'old_role' => $this->oldRole,
                'new_role' => $this->newRole,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team Profile',
        ];
    }
}
