<?php

namespace App\Notifications\User;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialRestoredNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Status Restored - ' . $this->official->team->name)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your official status for team ' . $this->official->team->name . ' has been restored.')
            ->line('Role: ' . $this->official->role)
            ->line('You now have access to all official features and responsibilities once again.')
            ->action('View Team Profile', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Status Restored',
            'message' => 'Your official status for team ' . $this->official->team->name . ' has been restored. Role: ' . $this->official->role,
            'type' => 'official_restored',
            'data' => [
                'official_id' => $this->official->id,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'role' => $this->official->role,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team Profile',
        ];
    }
}
