<?php

namespace App\Notifications\User;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialRemovedNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Status Removed - ' . $this->official->team->name)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your official status for team ' . $this->official->team->name . ' has been removed.')
            ->line('Role: ' . $this->official->role)
            ->line('You no longer have access to official features and responsibilities for this team.')
            ->line('If you believe this was done in error, please contact the team captain or tournament administrator.')
            ->action('Contact Support', url('/contact'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Status Removed',
            'message' => 'Your official status for team ' . $this->official->team->name . ' has been removed. Role: ' . $this->official->role,
            'type' => 'official_removed',
            'data' => [
                'official_id' => $this->official->id,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'role' => $this->official->role,
            ],
            'action_url' => url('/contact'),
            'action_text' => 'Contact Support',
        ];
    }
}
