<?php

namespace App\Notifications\User;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialQualificationsUpdatedNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Qualifications Updated - Team Official')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your qualifications as an official for team ' . $this->official->team->name . ' have been updated.')
            ->line('Your official status and role have been reviewed and updated based on your qualifications.')
            ->line('You may now have access to additional features and responsibilities.')
            ->action('View Team Profile', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Qualifications Updated',
            'message' => 'Your qualifications as an official for team ' . $this->official->team->name . ' have been updated.',
            'type' => 'official_qualifications_updated',
            'data' => [
                'official_id' => $this->official->id,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'role' => $this->official->role,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team Profile',
        ];
    }
}
