<?php

namespace App\Notifications\User;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialOtpNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official,
        protected string $otp
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Verification Code - Team Official')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your verification code is: **' . $this->otp . '**')
            ->line('This code will expire at: ' . $this->official->otp_expires_at)
            ->line('Please use this code to verify your official status.')
            ->action('Verify Official Status', route('officials.verify', ['official' => $this->official->id]));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Verification Code',
            'message' => 'Your verification code is ' . $this->otp . '. Use this to verify your official status.',
            'type' => 'official_otp',
            'data' => [
                'official_id' => $this->official->id,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'otp' => $this->otp,
                'expires_at' => $this->official->otp_expires_at,
            ],
            'action_url' => route('officials.verify', ['official' => $this->official->id]),
            'action_text' => 'Verify Official Status',
        ];
    }
}
