<?php

namespace App\Notifications\User;

use App\Models\Team;
use App\Models\Tournament;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialInvitationNotification extends BaseNotification
{
    public function __construct(
        protected Team $team,
        protected Tournament $tournament,
        protected string $role
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Invitation to Join "' . ($this->team->name ?? 'Team') . '" as ' . $this->role)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('You have been invited to join the team "' . ($this->team->name ?? 'Team') . '" as ' . $this->role . '.')
            ->line('Tournament: ' . ($this->tournament->name ?? ''))
            ->action('Review Invitation', url('/player/profile'))
            ->line('If you did not expect this, you can safely ignore the invitation.');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Invitation',
            'message' => 'You were invited to join team "' . ($this->team->name ?? 'Team') . '" as ' . $this->role . ' in ' . ($this->tournament->name ?? ''),
            'type' => 'official_invitation',
            'data' => [
                'team_id' => $this->team->id,
                'team_name' => $this->team->name,
                'tournament_id' => $this->tournament->id,
                'tournament_name' => $this->tournament->name,
                'role' => $this->role,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'Review Invitation',
        ];
    }
}
