<?php

namespace App\Notifications\User;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialEmailChangedOldNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official,
        protected string $newEmail
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Email Address Changed - Team Official')
            ->greeting('Hello')
            ->line('The email address for team official ' . $this->official->name . ' has been changed.')
            ->line('Previous email: ' . $notifiable->email)
            ->line('New email: ' . $this->newEmail)
            ->line('You will no longer receive official communications for team ' . $this->official->team->name . ' at this email address.')
            ->line('If you believe this change was made in error, please contact the team captain or tournament administrator.');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Email Address Changed',
            'message' => 'The email address for team official ' . $this->official->name . ' has been changed from ' . $notifiable->email . ' to ' . $this->newEmail,
            'type' => 'official_email_changed_old',
            'data' => [
                'official_id' => $this->official->id,
                'official_name' => $this->official->name,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'old_email' => $notifiable->email,
                'new_email' => $this->newEmail,
            ],
            'action_url' => null,
            'action_text' => null,
        ];
    }
}
