<?php

namespace App\Notifications\User;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialEmailChangedNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official,
        protected string $oldEmail
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Email Address Updated - Team Official')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your email address for team ' . $this->official->team->name . ' has been updated.')
            ->line('Previous email: ' . $this->oldEmail)
            ->line('New email: ' . $this->official->email)
            ->line('You will now receive all official communications at your new email address.')
            ->action('View Team Profile', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Email Address Updated',
            'message' => 'Your email address has been updated from ' . $this->oldEmail . ' to ' . $this->official->email . ' for team ' . $this->official->team->name,
            'type' => 'official_email_changed',
            'data' => [
                'official_id' => $this->official->id,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'old_email' => $this->oldEmail,
                'new_email' => $this->official->email,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team Profile',
        ];
    }
}
