<?php

namespace App\Notifications\User;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialAssignmentNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Official Assignment - ' . $this->official->team->name)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('You have been assigned as an official to team ' . $this->official->team->name)
            ->line('Role: ' . $this->official->role)
            ->action('Verify Official Status', route('officials.verify', ['official' => $this->official->id]));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Assignment',
            'message' => 'You have been assigned as ' . $this->official->role . ' to ' . $this->official->team->name,
            'type' => 'official_assignment',
            'data' => [
                'official_id' => $this->official->id,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'role' => $this->official->role,
            ],
            'action_url' => route('officials.verify', ['official' => $this->official->id]),
            'action_text' => 'Verify Official Status',
        ];
    }
}
