<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class MatchStreamingStartedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $matchId = null,
        protected ?string $tournamentName = null,
        protected ?string $streamingUrl = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Match Streaming Started')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Live streaming has started for a match in tournament ' . ($this->tournamentName ?? '') . '.')
            ->line('Streaming URL: ' . ($this->streamingUrl ?? 'TBA'))
            ->action('Watch Stream', url('/frontend/matches'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Match Streaming Started',
            'message' => 'Live streaming has started for a match in tournament ' . ($this->tournamentName ?? '') . '. Watch at ' . ($this->streamingUrl ?? 'TBA') . '.',
            'type' => 'match_streaming_started',
            'data' => [
                'match_id' => $this->matchId,
                'tournament_name' => $this->tournamentName,
                'streaming_url' => $this->streamingUrl,
            ],
            'action_url' => url('/frontend/matches'),
            'action_text' => 'Watch Stream',
        ];
    }
}