<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class MatchResultUpdatedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $matchId = null,
        protected ?string $tournamentName = null,
        protected ?string $oldResult = null,
        protected ?string $newResult = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Match Result Updated')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The result for a match in tournament ' . ($this->tournamentName ?? '') . ' has been updated.')
            ->line('Old result: ' . ($this->oldResult ?? 'N/A'))
            ->line('New result: ' . ($this->newResult ?? 'N/A'))
            ->action('View Match', url('/frontend/matches'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Match Result Updated',
            'message' => 'The result for a match in tournament ' . ($this->tournamentName ?? '') . ' has been updated from ' . ($this->oldResult ?? 'N/A') . ' to ' . ($this->newResult ?? 'N/A') . '.',
            'type' => 'match_result_updated',
            'data' => [
                'match_id' => $this->matchId,
                'tournament_name' => $this->tournamentName,
                'old_result' => $this->oldResult,
                'new_result' => $this->newResult,
            ],
            'action_url' => url('/frontend/matches'),
            'action_text' => 'View Match',
        ];
    }
}