<?php

namespace App\Notifications\User;

use App\Models\GameMatch;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class MatchRefereeAssignedNotification extends BaseNotification
{
    public function __construct(
        protected GameMatch $match,
        protected string $refereeName
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Referee Assigned to Match')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('A referee has been assigned to your match:')
            ->line('Match: ' . $this->match->team1->name . ' vs ' . $this->match->team2->name)
            ->line('Tournament: ' . $this->match->tournament->name)
            ->line('Referee: ' . $this->refereeName)
            ->action('View Match', route('matches.show', $this->match));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Referee Assigned',
            'message' => 'Referee ' . $this->refereeName . ' assigned to match.',
            'type' => 'match_referee_assigned',
            'data' => [
                'match_id' => $this->match->id,
                'team1_name' => $this->match->team1->name,
                'team2_name' => $this->match->team2->name,
                'tournament_name' => $this->match->tournament->name,
                'referee_name' => $this->refereeName,
            ],
            'action_url' => route('matches.show', $this->match),
            'action_text' => 'View Match',
        ];
    }
}