<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class FeaturedTournamentCompletedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Featured Tournament Completed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The featured tournament has concluded.')
            ->line('Tournament: ' . ($this->tournamentName ?? ''))
            ->action('View Results', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Featured Tournament Completed',
            'message' => 'The featured tournament has concluded: ' . ($this->tournamentName ?? ''),
            'type' => 'featured_tournament_completed',
            'data' => [
                'tournament_name' => $this->tournamentName,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Results',
        ];
    }
}
