<?php

namespace App\Notifications\Channels;

use Illuminate\Notifications\Channels\MailChannel;
use Illuminate\Support\Facades\Log;

class SafeMailChannel
{
    public function __construct(protected MailChannel $mailChannel)
    {
    }

    public function send($notifiable, $notification): void
    {
        try {
            $this->mailChannel->send($notifiable, $notification);
        } catch (\Throwable $e) {
            Log::warning('Mail transport failed for notification', [
                'notification_class' => get_class($notification),
                'notifiable_class' => is_object($notifiable) ? get_class($notifiable) : gettype($notifiable),
                'notifiable_id' => $notifiable->id ?? null,
                'message' => $e->getMessage(),
                'code' => $e->getCode(),
            ]);
            // Swallow exception to avoid failing the notification/job
        }
    }
}
