<?php

namespace App\Notifications\Admin;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserRoleChangedAdminNotification extends BaseNotification
{
	protected User $user;
	protected string $oldRole;
	protected string $newRole;

	public function __construct(User $user, string $oldRole, string $newRole)
	{
		$this->user = $user;
		$this->oldRole = $oldRole;
		$this->newRole = $newRole;
	}

	protected function buildMailMessage(object $notifiable): MailMessage
	{
		$subject = "User Role Changed: {$this->user->name}";
		
		return (new MailMessage)
			->subject($subject)
			->greeting("Hello {$notifiable->name},")
			->line("A user's role has been changed.")
			->line("User: {$this->user->name} ({$this->user->email})")
			->line("Previous role: {$this->oldRole}")
			->line("New role: {$this->newRole}")
			->action('View User Profile', route('admin.users.show', $this->user));
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'user_role_changed_admin',
			'title' => "User Role Changed",
			'message' => "User {$this->user->name} role changed from {$this->oldRole} to {$this->newRole}",
			'user_id' => $this->user->id,
			'user_name' => $this->user->name,
			'user_email' => $this->user->email,
			'old_role' => $this->oldRole,
			'new_role' => $this->newRole,
			'action_url' => route('admin.users.show', $this->user),
			'created_at' => now()->toISOString(),
		];
	}
}