<?php

namespace App\Notifications\Admin;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserRestoredAdminNotification extends BaseNotification
{
    protected $user;

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('User Account Restored - Admin Notification')
            ->greeting('Hello ' . $notifiable->name)
            ->line('A user account has been restored in the system.')
            ->line('**User Details:**')
            ->line('Name: ' . $this->user->name)
            ->line('Email: ' . $this->user->email)
            ->line('User Type: ' . $this->user->user_type)
            ->line('Restored At: ' . now()->format('Y-m-d H:i:s'))
            ->action('View User Details', url('/admin/users/' . $this->user->id))
            ->line('The user has been notified about their account restoration.')
            ->line('This is an automated notification for administrative purposes.')
            ->salutation('Best regards, The Milimus Tournament System');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'user_restored_admin',
            'title' => 'User Account Restored',
            'message' => 'User account for ' . $this->user->name . ' has been restored.',
            'user_id' => $this->user->id,
            'user_name' => $this->user->name,
            'user_email' => $this->user->email,
            'user_type' => $this->user->user_type,
            'restored_at' => now()->toISOString(),
            'action_url' => '/admin/users/' . $this->user->id,
            'action_text' => 'View User Details',
        ];
    }
} 