<?php

namespace App\Notifications\Admin;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserRegisteredAdminNotification extends BaseNotification
{
	protected User $user;

	public function __construct(User $user)
	{
		$this->user = $user;
	}

	protected function buildMailMessage(object $notifiable): MailMessage
	{
		$subject = "New User Registration: {$this->user->name}";
		
		return (new MailMessage)
			->subject($subject)
			->greeting("Hello {$notifiable->name},")
			->line("A new user has registered on the platform.")
			->line("User Details:")
			->line("• Name: {$this->user->name}")
			->line("• Email: {$this->user->email}")
			->line("• Registration Date: {$this->user->created_at->format('F j, Y g:i A')}")
			->action('View User Profile', route('admin.users.show', $this->user));
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'user_registered_admin',
			'title' => "New User Registration",
			'message' => "New user {$this->user->name} has registered",
			'user_id' => $this->user->id,
			'user_name' => $this->user->name,
			'user_email' => $this->user->email,
			'action_url' => route('admin.users.show', $this->user),
			'created_at' => now()->toISOString(),
		];
	}
}