<?php

namespace App\Notifications\Admin;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserPaymentStatusUpdatedAdminNotification extends BaseNotification
{
	protected User $user;
	protected string $oldStatus;
	protected string $newStatus;

	public function __construct(User $user, string $oldStatus, string $newStatus)
	{
		$this->user = $user;
		$this->oldStatus = $oldStatus;
		$this->newStatus = $newStatus;
	}

	protected function buildMailMessage(object $notifiable): MailMessage
	{
		$subject = "User Payment Status Updated: {$this->user->name}";
		
		return (new MailMessage)
			->subject($subject)
			->greeting("Hello {$notifiable->name},")
			->line("A user's payment status has been updated.")
			->line("User: {$this->user->name} ({$this->user->email})")
			->line("Previous status: {$this->oldStatus}")
			->line("New status: {$this->newStatus}")
			->action('View User Profile', route('admin.users.show', $this->user));
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'user_payment_status_updated_admin',
			'title' => "User Payment Status Updated",
			'message' => "User {$this->user->name} payment status changed from {$this->oldStatus} to {$this->newStatus}",
			'user_id' => $this->user->id,
			'user_name' => $this->user->name,
			'user_email' => $this->user->email,
			'old_status' => $this->oldStatus,
			'new_status' => $this->newStatus,
			'action_url' => route('admin.users.show', $this->user),
			'created_at' => now()->toISOString(),
		];
	}
}