<?php

namespace App\Notifications\Admin;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserPasswordChangedAdminNotification extends BaseNotification
{
	protected User $user;

	public function __construct(User $user)
	{
		$this->user = $user;
	}

	protected function buildMailMessage(object $notifiable): MailMessage
	{
		$subject = "User Password Changed: {$this->user->name}";
		
		return (new MailMessage)
			->subject($subject)
			->greeting("Hello {$notifiable->name},")
			->line("A user has changed their password.")
			->line("User: {$this->user->name} ({$this->user->email})")
			->line("Password changed at: {$this->user->updated_at->format('F j, Y g:i A')}")
			->line("Monitor for any suspicious activity.")
			->action('View User Profile', route('admin.users.show', $this->user));
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'user_password_changed_admin',
			'title' => "User Password Changed",
			'message' => "User {$this->user->name} has changed their password",
			'user_id' => $this->user->id,
			'user_name' => $this->user->name,
			'user_email' => $this->user->email,
			'action_url' => route('admin.users.show', $this->user),
			'created_at' => now()->toISOString(),
		];
	}
}