<?php

namespace App\Notifications\Admin;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserForceDeletedAdminNotification extends BaseNotification
{
    protected $user;

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('User Account Permanently Deleted - Admin Notification')
            ->greeting('Hello ' . $notifiable->name)
            ->line('A user account has been permanently deleted from the system.')
            ->line('**User Details:**')
            ->line('Name: ' . $this->user->name)
            ->line('Email: ' . $this->user->email)
            ->line('User Type: ' . $this->user->user_type)
            ->line('Permanently Deleted At: ' . now()->format('Y-m-d H:i:s'))
            ->line('**Warning:** This action is irreversible. The user account and all associated data have been permanently removed.')
            ->action('View Admin Dashboard', url('/admin/dashboard'))
            ->line('This is an automated notification for administrative purposes.')
            ->salutation('Best regards, The Milimus Tournament System');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'user_force_deleted_admin',
            'title' => 'User Account Permanently Deleted',
            'message' => 'User account for ' . $this->user->name . ' has been permanently deleted.',
            'user_id' => $this->user->id,
            'user_name' => $this->user->name,
            'user_email' => $this->user->email,
            'user_type' => $this->user->user_type,
            'force_deleted_at' => now()->toISOString(),
            'action_url' => '/admin/dashboard',
            'action_text' => 'View Dashboard',
            'warning' => 'This action is irreversible.',
        ];
    }
} 