<?php

namespace App\Notifications\Admin;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserDeletedAdminNotification extends BaseNotification
{
    protected $user;

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('User Account Deleted - Admin Notification')
            ->greeting('Hello ' . $notifiable->name)
            ->line('A user account has been deleted from the system.')
            ->line('**User Details:**')
            ->line('Name: ' . $this->user->name)
            ->line('Email: ' . $this->user->email)
            ->line('User Type: ' . $this->user->user_type)
            ->line('Deleted At: ' . now()->format('Y-m-d H:i:s'))
            ->line('**Note:** This account can be restored if needed.')
            ->action('View Admin Dashboard', url('/admin/dashboard'))
            ->line('This is an automated notification for administrative purposes.')
            ->salutation('Best regards, The Milimus Tournament System');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'user_deleted_admin',
            'title' => 'User Account Deleted',
            'message' => 'User account for ' . $this->user->name . ' has been deleted.',
            'user_id' => $this->user->id,
            'user_name' => $this->user->name,
            'user_email' => $this->user->email,
            'user_type' => $this->user->user_type,
            'deleted_at' => now()->toISOString(),
            'action_url' => '/admin/dashboard',
            'action_text' => 'View Dashboard',
            'note' => 'This account can be restored if needed.',
        ];
    }
} 