<?php

namespace App\Notifications\Admin;

use App\Models\Tournament;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentStartedAdminNotification extends BaseNotification
{
	protected Tournament $tournament;

	public function __construct(Tournament $tournament)
	{
		$this->tournament = $tournament;
	}

	protected function buildMailMessage(object $notifiable): MailMessage
	{
		$subject = "Tournament Started: {$this->tournament->name}";
		
		$mailMessage = (new MailMessage)
			->subject($subject)
			->greeting("Hello {$notifiable->name},")
			->line("A tournament has started.")
			->line("Tournament: {$this->tournament->name}")
			->line("Started at: " . now()->format('F j, Y g:i A'))
			->action('View Tournament', route('admin.tournaments.show', $this->tournament))
			->line("The tournament is now active and matches are being played.");

		return $mailMessage;
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'tournament_started',
			'title' => "Tournament Started",
			'message' => "Tournament '{$this->tournament->name}' has started",
			'tournament_id' => $this->tournament->id,
			'tournament_name' => $this->tournament->name,
			'start_date' => $this->tournament->start_date?->toISOString(),
			'action_url' => route('admin.tournaments.show', $this->tournament),
			'created_at' => now()->toISOString(),
		];
	}
} 