<?php

namespace App\Notifications\Admin;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentRestoredAdminNotification extends BaseNotification
{
	protected function buildMailMessage(object $notifiable): MailMessage
	{
		return (new MailMessage)
			->subject('Tournament Restored')
			->greeting('Hello ' . ($notifiable->name ?? ''))
			->line('A tournament has been restored.')
			->action('View Tournaments', url('/admin/tournaments'));
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'tournament_restored_admin',
			'title' => 'Tournament Restored',
			'message' => 'A tournament has been restored.',
			'action_url' => url('/admin/tournaments'),
			'action_text' => 'View Tournaments',
		];
	}
}
