<?php

namespace App\Notifications\Admin;

use App\Models\Tournament;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentRegistrationOpenedAdminNotification extends BaseNotification
{
	protected Tournament $tournament;

	public function __construct(Tournament $tournament)
	{
		$this->tournament = $tournament;
	}

	protected function buildMailMessage(object $notifiable): MailMessage
	{
		$subject = "Tournament Registration Opened: {$this->tournament->name}";
		
		$mailMessage = (new MailMessage)
			->subject($subject)
			->greeting("Hello {$notifiable->name},")
			->line("Tournament registration has been opened.")
			->line("Tournament: {$this->tournament->name}")
			->line("Registration opened at: " . now()->format('F j, Y g:i A'));

		if ($this->tournament->registration_end) {
			$mailMessage->line("Registration closes: " . $this->tournament->registration_end->format('F j, Y g:i A'));
		}

		$mailMessage->action('View Tournament', route('admin.tournaments.show', $this->tournament))
			->line("Teams can now register for this tournament.");

		return $mailMessage;
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'tournament_registration_opened',
			'title' => "Tournament Registration Opened",
			'message' => "Registration for tournament '{$this->tournament->name}' has been opened",
			'tournament_id' => $this->tournament->id,
			'tournament_name' => $this->tournament->name,
			'registration_start' => $this->tournament->registration_start?->toISOString(),
			'registration_end' => $this->tournament->registration_end?->toISOString(),
			'action_url' => route('admin.tournaments.show', $this->tournament),
			'created_at' => now()->toISOString(),
		];
	}
} 