<?php

namespace App\Notifications\Admin;

use App\Models\Tournament;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentRegistrationClosedAdminNotification extends BaseNotification
{
    protected Tournament $tournament;

    public function __construct(Tournament $tournament)
    {
        $this->tournament = $tournament;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        $subject = "Tournament Registration Closed: {$this->tournament->name}";
        
        return (new MailMessage)
            ->subject($subject)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Tournament registration has been closed.')
            ->line('Tournament Details:')
            ->line('• Name: ' . $this->tournament->name)
            ->line('• Status: ' . ucfirst($this->tournament->status))
            ->line('• Registration Closed At: ' . $this->tournament->updated_at->format('F j, Y g:i A'))
            ->action('View Tournament', url('/admin/tournaments/' . $this->tournament->id))
            ->line('Please review the final registration count and prepare for the tournament.');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Registration Closed',
            'message' => 'Registration closed for tournament "' . $this->tournament->name . '"',
            'type' => 'tournament_registration_closed_admin',
            'data' => [
                'tournament_id' => $this->tournament->id,
                'tournament_name' => $this->tournament->name,
                'status' => $this->tournament->status,
                'registration_closed_at' => $this->tournament->updated_at->toISOString(),
            ],
            'action_url' => url('/admin/tournaments/' . $this->tournament->id),
            'action_text' => 'View Tournament',
        ];
    }
} 