<?php

namespace App\Notifications\Admin;

use App\Models\Tournament;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentPublishedAdminNotification extends BaseNotification
{
	protected Tournament $tournament;

	public function __construct(Tournament $tournament)
	{
		$this->tournament = $tournament;
	}

	protected function buildMailMessage(object $notifiable): MailMessage
	{
		$subject = "Tournament Published: {$this->tournament->name}";
		
		$mailMessage = (new MailMessage)
			->subject($subject)
			->greeting("Hello {$notifiable->name},")
			->line("A tournament has been published and is now visible to users.")
			->line("Tournament: {$this->tournament->name}")
			->line("Published at: " . $this->tournament->published_at->format('F j, Y g:i A'))
			->action('View Tournament', route('admin.tournaments.show', $this->tournament))
			->line("The tournament is now live and accepting registrations.");

		return $mailMessage;
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'tournament_published',
			'title' => "Tournament Published",
			'message' => "Tournament '{$this->tournament->name}' has been published",
			'tournament_id' => $this->tournament->id,
			'tournament_name' => $this->tournament->name,
			'published_at' => $this->tournament->published_at->toISOString(),
			'action_url' => route('admin.tournaments.show', $this->tournament),
			'created_at' => now()->toISOString(),
		];
	}
} 