<?php

namespace App\Notifications\Admin;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentDeletedAdminNotification extends BaseNotification
{
	protected function buildMailMessage(object $notifiable): MailMessage
	{
		return (new MailMessage)
			->subject('Tournament Deleted')
			->greeting('Hello ' . ($notifiable->name ?? ''))
			->line('A tournament has been deleted.')
			->action('View Tournaments', url('/admin/tournaments'));
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'tournament_deleted_admin',
			'title' => 'Tournament Deleted',
			'message' => 'A tournament has been deleted.',
			'action_url' => url('/admin/tournaments'),
			'action_text' => 'View Tournaments',
		];
	}
}
