<?php

namespace App\Notifications\Admin;

use App\Models\Tournament;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentCompletedAdminNotification extends BaseNotification
{
	protected Tournament $tournament;

	public function __construct(Tournament $tournament)
	{
		$this->tournament = $tournament;
	}

	protected function buildMailMessage(object $notifiable): MailMessage
	{
		$subject = "Tournament Completed: {$this->tournament->name}";
		
		$mailMessage = (new MailMessage)
			->subject($subject)
			->greeting("Hello {$notifiable->name},")
			->line("A tournament has been completed successfully.")
			->line("Tournament: {$this->tournament->name}")
			->line("Completed at: " . $this->tournament->completed_at->format('F j, Y g:i A'))
			->action('View Tournament', route('admin.tournaments.show', $this->tournament))
			->line("Please review the tournament results and distribute prizes if applicable.");

		return $mailMessage;
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'tournament_completed',
			'title' => "Tournament Completed",
			'message' => "Tournament '{$this->tournament->name}' has been completed",
			'tournament_id' => $this->tournament->id,
			'tournament_name' => $this->tournament->name,
			'completed_at' => $this->tournament->completed_at->toISOString(),
			'action_url' => route('admin.tournaments.show', $this->tournament),
			'created_at' => now()->toISOString(),
		];
	}
} 