<?php

namespace App\Notifications\Admin;

use App\Models\Tournament;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentCancelledAdminNotification extends BaseNotification
{
	protected Tournament $tournament;

	public function __construct(Tournament $tournament)
	{
		$this->tournament = $tournament;
	}

	protected function buildMailMessage(object $notifiable): MailMessage
	{
		$subject = "Tournament Cancelled: {$this->tournament->name}";
		
		$mailMessage = (new MailMessage)
			->subject($subject)
			->greeting("Hello {$notifiable->name},")
			->line("A tournament has been cancelled.")
			->line("Tournament: {$this->tournament->name}")
			->line("Cancelled at: " . $this->tournament->cancelled_at->format('F j, Y g:i A'))
			->action('View Tournament', route('admin.tournaments.show', $this->tournament))
			->line("Please review the cancellation and process refunds if necessary.");

		return $mailMessage;
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'tournament_cancelled',
			'title' => "Tournament Cancelled",
			'message' => "Tournament '{$this->tournament->name}' has been cancelled",
			'tournament_id' => $this->tournament->id,
			'tournament_name' => $this->tournament->name,
			'cancelled_at' => $this->tournament->cancelled_at->toISOString(),
			'action_url' => route('admin.tournaments.show', $this->tournament),
			'created_at' => now()->toISOString(),
		];
	}
} 