<?php

namespace App\Notifications\Admin;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamRestoredAdminNotification extends BaseNotification
{
    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Restored')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('A team has been restored in the system.')
            ->action('View Teams', url('/admin/teams'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'team_restored_admin',
            'title' => 'Team Restored',
            'message' => 'A team has been restored in the system.',
            'action_url' => url('/admin/teams'),
            'action_text' => 'View Teams',
        ];
    }
}
