<?php

namespace App\Notifications\Admin;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamPaymentCompletedAdminNotification extends BaseNotification
{
    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Payment Completed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('A team payment has been completed.')
            ->action('View Payments', url('/admin/payments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'team_payment_completed_admin',
            'title' => 'Team Payment Completed',
            'message' => 'A team payment has been completed.',
            'action_url' => url('/admin/payments'),
            'action_text' => 'View Payments',
        ];
    }
}
