<?php

namespace App\Notifications\Admin;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamOfficialAssignedAdminNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Official Assigned - ' . $this->official->team->name)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('A new official has been assigned to team ' . $this->official->team->name . '.')
            ->line('Official: ' . $this->official->name)
            ->line('Role: ' . $this->official->role)
            ->line('Email: ' . $this->official->email)
            ->action('View Team', url('/admin/teams/' . $this->official->team->id));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Official Assigned',
            'message' => 'New official ' . $this->official->name . ' assigned to team ' . $this->official->team->name,
            'type' => 'team_official_assigned_admin',
            'data' => [
                'official_id' => $this->official->id,
                'official_name' => $this->official->name,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'role' => $this->official->role,
                'email' => $this->official->email,
            ],
            'action_url' => url('/admin/teams/' . $this->official->team->id),
            'action_text' => 'View Team',
        ];
    }
}
