<?php

namespace App\Notifications\Admin;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamDeletedAdminNotification extends BaseNotification
{
    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Deleted')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('A team has been deleted from the system.')
            ->action('View Teams', url('/admin/teams'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'team_deleted_admin',
            'title' => 'Team Deleted',
            'message' => 'A team has been deleted from the system.',
            'action_url' => url('/admin/teams'),
            'action_text' => 'View Teams',
        ];
    }
}
