<?php

namespace App\Notifications\Admin;

use App\Models\Team;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamCreatedAdminNotification extends BaseNotification
{
    public function __construct(
        protected Team $team
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('New Team Created')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('A new team has been created.')
            ->line('Team Name: ' . ($this->team->name ?? 'Unknown'))
            ->line('Captain: ' . ($this->team->captain->name ?? 'Unknown'))
            ->line('Tournament: ' . ($this->team->tournament->name ?? 'Unknown'))
            ->action('View Team', url('/admin/teams/' . $this->team->id))
            ->line('Please review this new team registration.');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'New Team Created',
            'message' => 'Team "' . ($this->team->name ?? 'Unknown') . '" has been created by ' . ($this->team->captain->name ?? 'Unknown') . ' for ' . ($this->team->tournament->name ?? 'Unknown'),
            'type' => 'team_created',
            'data' => [
                'team_id' => $this->team->id,
                'team_name' => $this->team->name ?? 'Unknown',
                'captain_id' => $this->team->captain->id ?? null,
                'captain_name' => $this->team->captain->name ?? 'Unknown',
                'tournament_id' => $this->team->tournament->id ?? null,
                'tournament_name' => $this->team->tournament->name ?? 'Unknown',
            ],
            'action_url' => url('/admin/teams/' . $this->team->id),
            'action_text' => 'View Team',
        ];
    }
}
