<?php

namespace App\Notifications\Admin;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamCaptainChangedAdminNotification extends BaseNotification
{
    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Captain Changed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('A team captain has been changed.')
            ->action('View Teams', url('/admin/teams'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'team_captain_changed_admin',
            'title' => 'Team Captain Changed',
            'message' => 'A team captain has been changed.',
            'action_url' => url('/admin/teams'),
            'action_text' => 'View Teams',
        ];
    }
}
