<?php

namespace App\Notifications\Admin;

use App\Models\Player;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class PlayerVerificationUpdatedAdminNotification extends BaseNotification
{
    public function __construct(
        protected Player $player,
        protected string $oldStatus,
        protected string $newStatus
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Player Verification Status Updated')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('A player verification status has been updated.')
            ->line('Player: ' . ($this->player->display_name ?? $this->player->user->name ?? 'Unknown'))
            ->line('Old Verification Status: ' . $this->oldStatus)
            ->line('New Verification Status: ' . $this->newStatus)
            ->line('Tournament: ' . ($this->player->tournament->name ?? ''))
            ->action('View Player', url('/admin/players/' . $this->player->id))
            ->line('Please review this verification update.');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Player Verification Updated',
            'message' => 'Player ' . ($this->player->display_name ?? $this->player->user->name ?? 'Unknown') . ' verification status changed from ' . $this->oldStatus . ' to ' . $this->newStatus . ' in ' . ($this->player->tournament->name ?? ''),
            'type' => 'player_verification_updated',
            'data' => [
                'player_id' => $this->player->id,
                'player_name' => $this->player->display_name ?? $this->player->user->name ?? 'Unknown',
                'old_verification_status' => $this->oldStatus,
                'new_verification_status' => $this->newStatus,
                'tournament_id' => $this->player->tournament->id ?? null,
                'tournament_name' => $this->player->tournament->name ?? '',
            ],
            'action_url' => url('/admin/players/' . $this->player->id),
            'action_text' => 'View Player',
        ];
    }
}
