<?php

namespace App\Notifications\Admin;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialVerificationUpdatedAdminNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official,
        protected bool $wasVerified,
        protected bool $isVerified
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        $status = $this->isVerified ? 'verified' : 'unverified';
        $action = $this->isVerified ? 'has been verified' : 'verification has been revoked';
        
        return (new MailMessage)
            ->subject('Official Verification Status Updated - ' . $this->official->team->name)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The verification status of official ' . $this->official->name . ' ' . $action . '.')
            ->line('Team: ' . $this->official->team->name)
            ->line('Role: ' . $this->official->role)
            ->line('Current status: ' . $status)
            ->action('View Team', url('/admin/teams/' . $this->official->team->id));
    }

    public function toDatabase(object $notifiable): array
    {
        $status = $this->isVerified ? 'verified' : 'unverified';
        $action = $this->isVerified ? 'has been verified' : 'verification has been revoked';
        
        return [
            'title' => 'Official Verification Status Updated',
            'message' => 'Official ' . $this->official->name . ' ' . $action . ' for team ' . $this->official->team->name,
            'type' => 'official_verification_updated_admin',
            'data' => [
                'official_id' => $this->official->id,
                'official_name' => $this->official->name,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'role' => $this->official->role,
                'was_verified' => $this->wasVerified,
                'is_verified' => $this->isVerified,
                'status' => $status,
            ],
            'action_url' => url('/admin/teams/' . $this->official->team->id),
            'action_text' => 'View Team',
        ];
    }
}
