<?php

namespace App\Notifications\Admin;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialRoleChangedAdminNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official,
        protected string $oldRole,
        protected string $newRole
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Role Changed - ' . $this->official->team->name)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The role of official ' . $this->official->name . ' has been changed.')
            ->line('Team: ' . $this->official->team->name)
            ->line('Previous role: ' . $this->oldRole)
            ->line('New role: ' . $this->newRole)
            ->action('View Team', url('/admin/teams/' . $this->official->team->id));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Role Changed',
            'message' => 'Official ' . $this->official->name . ' role changed from ' . $this->oldRole . ' to ' . $this->newRole . ' for team ' . $this->official->team->name,
            'type' => 'official_role_changed_admin',
            'data' => [
                'official_id' => $this->official->id,
                'official_name' => $this->official->name,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'old_role' => $this->oldRole,
                'new_role' => $this->newRole,
            ],
            'action_url' => url('/admin/teams/' . $this->official->team->id),
            'action_text' => 'View Team',
        ];
    }
}
