<?php

namespace App\Notifications\Admin;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialRestoredAdminNotification extends BaseNotification
{
    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Restored')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('An official has been restored in the system.')
            ->action('View Officials', url('/admin/officials'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'official_restored_admin',
            'title' => 'Official Restored',
            'message' => 'An official has been restored in the system.',
            'action_url' => url('/admin/officials'),
            'action_text' => 'View Officials',
        ];
    }
}
