<?php

namespace App\Notifications\Admin;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialRemovedAdminNotification extends BaseNotification
{
    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Removed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('An official has been removed from the system.')
            ->action('View Officials', url('/admin/officials'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'official_removed_admin',
            'title' => 'Official Removed',
            'message' => 'An official has been removed from the system.',
            'action_url' => url('/admin/officials'),
            'action_text' => 'View Officials',
        ];
    }
}
