<?php

namespace App\Notifications\Admin;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialQualificationsUpdatedAdminNotification extends BaseNotification
{
    public function __construct(
        protected TeamOfficial $official,
        protected ?string $oldQualifications,
        protected ?string $newQualifications
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Qualifications Updated - ' . $this->official->team->name)
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The qualifications of official ' . $this->official->name . ' have been updated.')
            ->line('Team: ' . $this->official->team->name)
            ->line('Role: ' . $this->official->role)
            ->line('Previous qualifications: ' . ($this->oldQualifications ?? 'None'))
            ->line('New qualifications: ' . ($this->newQualifications ?? 'None'))
            ->action('View Team', url('/admin/teams/' . $this->official->team->id));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Qualifications Updated',
            'message' => 'Official ' . $this->official->name . ' qualifications updated for team ' . $this->official->team->name,
            'type' => 'official_qualifications_updated_admin',
            'data' => [
                'official_id' => $this->official->id,
                'official_name' => $this->official->name,
                'team_id' => $this->official->team->id,
                'team_name' => $this->official->team->name,
                'role' => $this->official->role,
                'old_qualifications' => $this->oldQualifications,
                'new_qualifications' => $this->newQualifications,
            ],
            'action_url' => url('/admin/teams/' . $this->official->team->id),
            'action_text' => 'View Team',
        ];
    }
}
