<?php

namespace App\Notifications\Admin;

use App\Models\TeamOfficial;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class OfficialOtpGeneratedAdminNotification extends BaseNotification
{
    protected TeamOfficial $official;

    public function __construct(TeamOfficial $official)
    {
        $this->official = $official;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official OTP Generated')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('An OTP has been generated for an official.')
            ->line('Official Details:')
            ->line('• Name: ' . ($this->official->user->name ?? 'Unknown'))
            ->line('• Email: ' . ($this->official->user->email ?? 'Unknown'))
            ->line('• Role: ' . ($this->official->role ?? 'Unknown'))
            ->line('• Team: ' . ($this->official->team->name ?? 'Unknown'))
            ->line('• Tournament: ' . ($this->official->tournament->name ?? 'Unknown'))
            ->line('• OTP Generated At: ' . now()->format('F j, Y g:i A'))
            ->action('View Official', url('/admin/officials/' . $this->official->id))
            ->line('Please monitor this official\'s verification process.');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official OTP Generated',
            'message' => 'An OTP has been generated for official ' . ($this->official->user->name ?? 'Unknown') . ' in team ' . ($this->official->team->name ?? 'Unknown'),
            'type' => 'official_otp_generated_admin',
            'data' => [
                'official_id' => $this->official->id,
                'official_name' => $this->official->user->name ?? 'Unknown',
                'official_email' => $this->official->user->email ?? 'Unknown',
                'official_role' => $this->official->role ?? 'Unknown',
                'team_id' => $this->official->team->id ?? null,
                'team_name' => $this->official->team->name ?? 'Unknown',
                'tournament_id' => $this->official->tournament->id ?? null,
                'tournament_name' => $this->official->tournament->name ?? 'Unknown',
                'otp_generated_at' => now()->toISOString(),
            ],
            'action_url' => url('/admin/officials/' . $this->official->id),
            'action_text' => 'View Official',
        ];
    }
}
