<?php

namespace App\Notifications\Admin;

use App\Models\GameMatch;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class MatchStreamingStartedAdminNotification extends BaseNotification
{
	protected GameMatch $match;

	public function __construct(GameMatch $match)
	{
		$this->match = $match;
	}

	protected function buildMailMessage(object $notifiable): MailMessage
	{
		$subject = "Live Stream Started: {$this->match->team1->name} vs {$this->match->team2->name}";
		
		return (new MailMessage)
			->subject($subject)
			->greeting("Hello {$notifiable->name},")
			->line("Live streaming has started for a match.")
			->line("Match Details:")
			->line("• Teams: {$this->match->team1->name} vs {$this->match->team2->name}")
			->line("• Tournament: {$this->match->tournament->name}")
			->line("• Stream started at: " . now()->format('F j, Y g:i A'))
			->action('Monitor Stream', route('admin.matches.show', $this->match));
	}

	public function toDatabase(object $notifiable): array
	{
		return [
			'type' => 'match_streaming_started_admin',
			'title' => "Live Stream Started",
			'message' => "Live stream started for {$this->match->team1->name} vs {$this->match->team2->name}",
			'match_id' => $this->match->id,
			'team1_name' => $this->match->team1->name,
			'team2_name' => $this->match->team2->name,
			'tournament_name' => $this->match->tournament->name,
			'action_url' => route('admin.matches.show', $this->match),
			'created_at' => now()->toISOString(),
		];
	}
} 