<?php

namespace App\Models\Frontend;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TournamentHighlight extends Model
{
    use HasFactory;

    protected $table = 'frontend_tournament_highlights';

    protected $fillable = [
        'icon',
        'title',
        'description',
        'value',
        'color',
        'sort_order',
        'status',
        'active'
    ];

    protected $casts = [
        'sort_order' => 'integer',
        'active' => 'boolean'
    ];

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('active', true);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }

    // Accessors
    public function getIconClassAttribute()
    {
        return $this->color ?: 'text-primary';
    }
} 