<?php

namespace App\Models\Frontend;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TournamentAchievement extends Model
{
    use HasFactory;

    protected $table = 'frontend_tournament_achievements';

    protected $fillable = [
        'year',
        'title',
        'description',
        'participants',
        'prize_pool',
        'winner',
        'runner_up',
        'sort_order',
        'status',
        'active'
    ];

    protected $casts = [
        'year' => 'integer',
        'sort_order' => 'integer',
        'active' => 'boolean',
        'prize_pool' => 'decimal:2'
    ];

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('active', true);
    }

    public function scopeByYear($query, $year)
    {
        return $query->where('year', $year);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('year', 'desc');
    }

    // Accessors
    public function getFormattedPrizePoolAttribute()
    {
        return $this->prize_pool ? 'Ksh. ' . number_format($this->prize_pool, 0) : null;
    }
} 