<?php

namespace App\Models\Frontend;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Testimonial extends Model
{
    use HasFactory;

    protected $table = 'frontend_testimonials';

    protected $fillable = [
        'name',
        'role',
        'team',
        'image',
        'rating',
        'quote',
        'achievement',
        'year',
        'sort_order',
        'status',
        'active',
        'featured'
    ];

    protected $casts = [
        'rating' => 'integer',
        'sort_order' => 'integer',
        'active' => 'boolean',
        'featured' => 'boolean',
        'year' => 'integer'
    ];

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('active', true);
    }

    public function scopeFeatured($query)
    {
        return $query->where('featured', true);
    }

    public function scopeByRating($query, $minRating = 4)
    {
        return $query->where('rating', '>=', $minRating);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order')->orderBy('created_at', 'desc');
    }

    // Accessors
    public function getImageUrlAttribute()
    {
        return $this->image ? asset($this->image) : null;
    }

    public function getRatingStarsAttribute()
    {
        return str_repeat('⭐', $this->rating);
    }

    // Helper methods
    public function getShortQuoteAttribute()
    {
        return \Str::limit($this->quote, 100);
    }
} 