<?php

namespace App\Models\Frontend;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sponsor extends Model
{
    use HasFactory;

    protected $table = 'frontend_sponsors';

    protected $fillable = [
        'name',
        'category',
        'logo',
        'description',
        'tier',
        'website_url',
        'contact_email',
        'contact_phone',
        'sort_order',
        'status',
        'active'
    ];

    protected $casts = [
        'sort_order' => 'integer',
        'active' => 'boolean'
    ];

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('active', true);
    }

    public function scopeByTier($query, $tier)
    {
        if ($tier && $tier !== 'all') {
            return $query->where('tier', $tier);
        }
        return $query;
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order')->orderBy('name');
    }

    // Static methods
    public static function getTiers()
    {
        return [
            'platinum' => 'Platinum',
            'gold' => 'Gold',
            'silver' => 'Silver',
            'bronze' => 'Bronze'
        ];
    }

    public static function getCategories()
    {
        return [
            'equipment' => 'Equipment Partner',
            'media' => 'Media Partner',
            'nutrition' => 'Nutrition Partner',
            'financial' => 'Financial Partner',
            'technology' => 'Technology Partner',
            'hospitality' => 'Hospitality Partner'
        ];
    }

    // Accessors
    public function getLogoUrlAttribute()
    {
        return $this->logo ? asset($this->logo) : null;
    }

    public function getTierColorAttribute()
    {
        $colors = [
            'platinum' => 'text-gray-400',
            'gold' => 'text-yellow-500',
            'silver' => 'text-gray-300',
            'bronze' => 'text-orange-600'
        ];

        return $colors[$this->tier] ?? 'text-gray-500';
    }
} 